﻿using System.Linq;

namespace Framework
{
    /// <summary>
    /// string[] の拡張メソッドです。
    /// </summary>
    public static class StringArrayExtension
    {
        /// <summary>
        /// 文字列配列中から、nullまたは空文字列の要素を除いた配列を生成して返します。
        /// nullで起動した場合、nullを返します。
        /// </summary>
        public static string[] RemoveEmpties(this string[] target)
        {
            if (target == null)
                return null;

            return target.Where(s => s.IsNotEmpty()).ToArray();
        }
    }
}
